import { useEffect, useState } from "react";

const Admin = () => {
  const [seed, setSeed] = useState('');
  const [newSeed, setNewSeed] = useState('');

  useEffect(() => {
    fetch(`${process.env.PUBLIC_URL}/seed`)
      .then(response => response.json())
      .then(data => setSeed(data.seed));
  }, []);

  const submitSeed = () => {
    fetch(`${process.env.PUBLIC_URL}/seed`, {
      method: "POST",
      headers: {
        "Content-Type": "application/json"
      },
      body: JSON.stringify({ "seed": newSeed })
    }).then(response => response.json())
      .then(data => {
        console.log(data);
        if(data.result === "ok") setSeed(newSeed);
      });
  }

  return (
    <div className="admin">
      <div className="cur-seed">
        Current seed: [<strong>{seed || "NOT SET"}</strong>]
      </div>
      <div className="new-seed">
        <label htmlFor="seed">New Seed:</label>
        <input type="text" id="seed" value={newSeed} onChange={(ev) => setNewSeed(ev.target.value)} />
        <button onClick={submitSeed}>SET</button>
      </div>
    </div>
  );
}

export default Admin;
